

MQ_CompScans_AlltoAll <- function(datafA,dataf){

  datafA$Unique_scan <- paste0(datafA$Spectrum,"_",datafA$Retention.time,"_",datafA$PTM.positions)
  dataf$Unique_scan <- paste0(dataf$Spectrum,"_",dataf$Retention.time,"_",dataf$PTM.positions)
  datafA$PTM_final_prob <- (1-datafA$PEP)*datafA$PTM_Prob
  dataf$PTM_final_prob <- (1-dataf$PEP)*dataf$PTM_Prob
  datafA$Amino <- str_sub(substr(datafA$Sequence,1,datafA$PTM.positions),-1)
  dataf$Amino <- str_sub(substr(dataf$Sequence,1,dataf$PTM.positions),-1)
  dataf$nPhos <- str_count(dataf$Modified.sequence,"\\(Phospho")

ReduceddatafA <- subset(datafA,select = c(Unique_scan,Sequence,Amino,PTM_final_prob, PTM.positions, PEP, PTM_Prob))

ReduceddatafA <- ReduceddatafA %>% dplyr::rename(
  pASTY_Score = PTM_final_prob,
  pASTY_PEP = PEP,
  pASTY_PTMprob = PTM_Prob
)
Reduceddataf <- subset(dataf,select = c(Unique_scan,Sequence,PTM_final_prob, PTM.positions, PEP, PTM_Prob,nPhos))

Reduceddataf <- Reduceddataf %>% dplyr::rename(
  SequenceSTY = Sequence,
  PTM.positionsSTY= PTM.positions,
  pSTY_Score = PTM_final_prob,
  pSTY_PEP = PEP,
  pSTY_PTMprob = PTM_Prob
)


dataf_Merged <- merge(x=ReduceddatafA,y=Reduceddataf,by="Unique_scan", all= TRUE)
dataf_Merged<- dataf_Merged %>% group_by(Unique_scan) %>% dplyr::mutate(count_S = n())
dataf_Merged<- dataf_Merged %>% group_by(Unique_scan) %>% dplyr::mutate(count_M = n_distinct(PTM.positions))


dataf_Merged$SeqMatch <- ifelse(dataf_Merged$Sequence==dataf_Merged$SequenceSTY,1,0)
dataf_Merged$PTM_Match <- ifelse(dataf_Merged$Sequence==dataf_Merged$SequenceSTY&dataf_Merged$PTM.positions==dataf_Merged$PTM.positionsSTY,1,0)
dataf_Merged$SiteID <- paste0(dataf_Merged$Unique_scan,"_", dataf_Merged$PTM.positions)
dataf_Merged <- dataf_Merged %>% distinct(SiteID, .keep_all = TRUE)
return(dataf_Merged)

}
